//=============================================================================
// LiquorBottle.
//=============================================================================
class VodkaBottle extends DeusExPickup;

var() int MinDamageToBreak;
var int HealAmount;
var bool bCommi;

simulated function bool TestMPBeltSpot(int BeltSpot)
{
  if (bCommi && DeusExPlayer(Owner).Alliance == 'Commi')
  {
   return (BeltSpot == 9);
  }
   return (BeltSpot > 0 && BeltSpot < 4);
}

function TakeDamage(int Damage, Pawn EventInstigator, Vector HitLocation, Vector Momentum, name DamageType)
{
 if ((Damage >= MinDamageToBreak) && (RespawnTime == 0))
  BreakItSmashIt(fragType, (CollisionRadius + CollisionHeight) / 2);
}


function inventory SpawnCopy( pawn Other )
{
	local inventory Copy;

	Copy = Super.SpawnCopy(Other);
	Copy.bTossedOut = False;

	return Copy;
}

function DropFrom(vector StartLocation)
{

   if (Level.Netmode != NM_Standalone)
      bTossedOut = true;
	Super.DropFrom(StartLocation);
}

function BecomePickup()
{
	Super.BecomePickup();

   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 15.0;
}

state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local DeusExPlayer player;
		
		Super.BeginState();

		player = DeusExPlayer(Owner);
		if (player != None)
		{
			if (Player.alliance == 'Commi' && bCommi)
			 Player.HealPlayer(HealAmount, False);
			player.drugEffectTimer += 7.5;
                        if (Player.drugEffectTimer > 50) player.TakeDamage(5, Player, Player.Location, Normal(Player.Velocity), 'Drowned');
		}

		UseOnce();
	}
Begin:
}

defaultproperties
{
     bBreakable=False
     bBlockPlayers=True
     bBlockActors=True
     bCollideActors=True
     bProjTarget=True
     maxCopies=15
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="Vodka"
     ItemArticle="some"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.LiquorBottle'
     PickupViewMesh=LodMesh'DeusExItems.LiquorBottle'
     ThirdPersonMesh=LodMesh'DeusExItems.LiquorBottle'
     LandSound=Sound'DeusExSounds.Generic.GlassHit1'
     Icon=Texture'DeusExUI.Icons.BeltIconLiquorBottle'
     largeIcon=Texture'DeusExUI.Icons.LargeIconLiquorBottle'
     largeIconWidth=20
     largeIconHeight=48
     Description="The label is torn off, but it looks like some of the good stuff."
     beltDescription="VODKA"
     Mesh=LodMesh'DeusExItems.LiquorBottle'
     CollisionRadius=4.620000
     CollisionHeight=12.500000
     Mass=10.000000
     Buoyancy=8.000000
     MinDamageToBreak=5
     HealAmount=35
     bCommi=True
}
